/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.tools.Util;
import java.awt.Color;

public class PlanFolder
extends Plan {
    protected boolean localScope;

    protected PlanFolder(Aladin aladin, String label) {
        this.aladin = aladin;
        this.type = 11;
        this.folder = 0;
        this.flagOk = false;
        this.setLabel(label);
        this.c = Color.black;
        this.askActive = true;
        this.localScope = false;
        this.headerFits = null;
    }

    protected PlanFolder(Aladin aladin, String label, int folderNiv, boolean localScope) {
        this.aladin = aladin;
        this.type = 11;
        this.folder = folderNiv;
        this.flagOk = true;
        if (label == null) {
            label = "Fold";
        }
        this.setLabel(label);
        this.c = Color.black;
        this.askActive = true;
        this.headerFits = null;
        this.localScope = localScope;
    }

    protected PlanFolder(Aladin aladin) {
        this.aladin = aladin;
        this.type = 11;
        this.flagOk = true;
    }

    @Override
    protected void setPropertie(String prop, String specif, String value) throws Exception {
        if (prop.equalsIgnoreCase("LocalScope")) {
            this.localScope = value.equalsIgnoreCase("true");
        } else if (prop.equalsIgnoreCase("scope")) {
            this.localScope = value.equalsIgnoreCase("local");
        }
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        if (this.headerFits != null) {
            PlanFolder.ADD(buf, "\n* Provenance: ", this.headerFits.getStringFromHeader("ORIGIN"));
            PlanFolder.ADD(buf, "\n* Survey: ", this.headerFits.getStringFromHeader("SURVEY"));
            PlanFolder.ADD(buf, "\n* Instrument: ", this.headerFits.getStringFromHeader("INSTRUME"));
        }
    }

    protected String getStatusItems() {
        StringBuffer rep = null;
        Plan[] p = this.aladin.calque.getFolderPlan(this, false);
        for (int i = 0; i < p.length; ++i) {
            if (rep == null) {
                rep = new StringBuffer();
            }
            rep.append("Item    " + Util.align("[" + Plan.Tp[p[i].type] + "]", 12) + p[i].label + "\n");
        }
        return rep == null ? null : rep.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getTargetQuery() {
        try {
            Calque calque = this.aladin.calque;
            synchronized (calque) {
                int n = this.aladin.calque.getIndex(this);
                return this.aladin.calque.plan[n + 1].getTargetQuery();
            }
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String getLabel() {
        int p = (int)this.getPourcent();
        if (p > 0) {
            return Util.align(this.label, 7, "..") + p;
        }
        return super.getLabel();
    }

    @Override
    protected boolean Free() {
        super.Free();
        this.localScope = false;
        this.headerFits = null;
        return true;
    }

    @Override
    protected boolean isSync() {
        return this.flagOk;
    }

    @Override
    public void setOpacityLevel(float opacityLevel) {
        super.setOpacityLevel(opacityLevel);
        for (Plan p : this.aladin.calque.getFolderPlan(this, false)) {
            if (!this.aladin.calque.canBeTransparent(p)) continue;
            p.setOpacityLevel(opacityLevel);
        }
    }

    @Override
    public String getBody() {
        String body = null;
        boolean first = true;
        for (Plan p : this.aladin.calque.getFolderPlan(this, false)) {
            if (first) {
                body = p.getBody();
                if (body == null) {
                    return null;
                }
                first = false;
                continue;
            }
            if (body.equals(p.getBody())) continue;
            return null;
        }
        return body;
    }
}

